# Gamma WaveGrad

___
## About
    Generative diffusion processes are an emerging and effective tool for image and speech generation. In the existing methods, the underlying noise distribution of the diffusion process is Gaussian noise. However, fitting distributions with more degrees of freedom could improve the performance of such generative models. In this work, we investigate other types of noise distribution for the diffusion process. Specifically, we introduce the Denoising Diffusion Gamma Model (DDGM) and show that noise from Gamma distribution provides improved results for image and speech generation. Our approach preserves the ability to efficiently sample state in the training diffusion process while using Gamma noise.
___
## Installation

Install requirements:
```bash
pip install -r requirements.txt
```

___
## Training

#### 1 Preparing data

1. Make train and test filelists of your audio data like ones included into `filelists` folder.
2. Make a configuration file* in `configs` folder.

#### 2 Start training

```
bash runs/train.sh
```

#### 3 Tensorboard and logging

To track your training process run tensorboard by `tensorboard --logdir=logs/YOUR_LOGDIR_FOLDER`. All logging information and checkpoints will be stored in `logs/YOUR_LOGDIR_FOLDER`. `logdir` is specified in config file.

#### 4 Noise schedule grid search

Once model is trained, grid search for the best schedule* for a needed number of iterations in [`notebooks/inference.ipynb`](notebooks/inference.ipynb). The code supports parallelism, so you can specify more than one number of jobs to accelerate the search.

***Note**: grid search is necessary just for a small number of iterations (like 6 or 7). For larger number just try Fibonacci sequence `benchmark.fibonacci(...)` initialization: I used it for 25 iteration and it works well. From good 25-iteration schedule, for example, you can build a higher-order schedule by copying elements.

##### Noise schedules


* 25-iteration schedule was obtained using Fibonacci sequence `benchmark.fibonacci(...)`.
* 50-iteration schedule was obtained by repeating elements from 25-iteration scheme.
* 100-iteration schedule was obtained in the same way.
* 1000-iteration schedule was obtained in the same way.

___
## Inference

#### CLI

Put your mel-spectrograms in some folder. Make a filelist. Then run this command with your own arguments:

```bash
sh runs/inference.sh -c <your-config> -ch <your-checkpoint> -ns <your-noise-schedule> -m <your-mel-filelist> -v "yes"
```

#### Jupyter Notebook

More inference details are provided in [`notebooks/inference.ipynb`](notebooks/inference.ipynb). There you can also find how to set a noise schedule for the model and make grid search for the best scheme.

___
### References and Acknowledgements


This code is based on the implementation of [Wavegrad](https://arxiv.org/pdf/2009.00713.pdf) available here : [https://github.com/ivanvovk/WaveGrad](https://github.com/ivanvovk/WaveGrad)
___
